#declare column_diameter = 1;
#declare column_radius = column_diameter/2;
#declare column_parts = 1;
#declare column_height = temple_height;
#declare column_part_height = column_height/column_parts;
#declare groove_count = 21;
#declare y_up = 1.1;
#declare y_down = -.1;
#declare part_scale = .92;
#declare base_radius = column_radius*sqrt(2);
#declare base_height = 4/12;

#macro x_from_y (y_n)
	(part_scale-1)*y_n+1
#end

#declare groove = cylinder {
	<x_from_y(y_down),y_down,0>,<x_from_y(y_up),y_up,0>,.1
	scale <column_radius,column_part_height,column_radius>
}

#declare columnBasePart = superellipsoid {
	< .1, .1 >
	translate <0, 1, 0>
	scale .5
	scale <base_radius*2, base_height, base_radius*2>
}
#declare columnBase = merge {
	#declare baseParts = 2;
	#declare currentPart = 1;
	#while (currentPart <= baseParts)
		object { columnBasePart
			rotate <0, 90*currentPart/baseParts, 0>
		}
		#declare currentPart = currentPart + 1;
	#end
}

#declare column = union {
	difference {
		cone {
			<0,0,0>,column_radius,
			<0,column_part_height,0>,part_scale*column_radius
		}
		#declare current_groove = 0;
		#while (current_groove < groove_count)
			object { groove
				rotate <0,current_groove*360/groove_count,0>
			}
			#declare current_groove = current_groove + 1;
		#end
	}
	
	object { columnBase }
	object { columnBase
		translate <0, temple_height-base_height, 0>
	}
}

